<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Http\Requests\API\Therapists\TherapistEvents\CreateRequest;
use App\Http\Resources\API\EventsResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistEventsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_events.index');
      // $this->middleware('permission:therapist_events.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_events.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_events.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_events.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_events.import',['only' => ['import']])
      // $this->middleware('permission:therapist_events.update|therapist_events.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_events =  $therapist->therapist_events()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_events =  $therapist_events->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_events =  $therapist_events->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_events = $therapist_events->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_events = $therapist_events->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_events = $therapist_events->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_events = $therapist_events->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_events = $therapist_events->get();
        return $therapist_events;
      }
      $totalTherapistCertifications = $therapist_events->count();
      $therapist_events = $therapist_events->paginate($req->perPage);
      $therapist_events = EventsResource::collection($therapist_events)->response()->getData(true);

      return $therapist_events;
    }
    $therapist_events = EventsResource::collection($therapist->therapist_events()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_events;
  }

  /********* FETCH ALL TherapistEvents ***********/
    public function index()
    {
        $therapist_events =  $this->getter();
        $response = generateResponse($therapist_events,count($therapist_events['data']) > 0 ? true:false,'TherapistEvents Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistEvents FOR Search ***********/
   public function filter(Request $request){
     $therapist_events = $this->getter($request);
     $response = generateResponse($therapist_events,count($therapist_events['data']) > 0 ? true:false,'Filter TherapistEvents Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistEvent ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['created_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadFile($request,'image','therapist_events');
        $therapist_event = $therapist->therapist_events()->create($data);
        $therapist_event->slug = Str::slug($therapist_event->name . ' ' . $therapist_event->id, '-');
        $therapist_event->save();
        $therapist_event->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_event = $therapist->therapist_posts()->withAll()->find($therapist_event->id);
        $therapist_event = new EventsResource($therapist_event);
      $response = generateResponse($therapist_event,true ,'TherapistEvents Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Event $therapist_event)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_event->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_event = $therapist->therapist_events()->withAll()->find($therapist_event->id);
        if($therapist_event){
          $therapist_event = new EventsResource($therapist_event);
          $response = generateResponse($therapist_event,true,'TherapistEvent Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistEvent Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistEvent ***********/
    public function update(CreateRequest $request, Event $therapist_event)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_event->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadFile($request,'image','therapist_events',$therapist_event->image);
        } else {
            $data['image'] = $therapist_event->image;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_event->id, '-');
        $therapist_event->update($data);
        $therapist_event->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_event = $therapist->therapist_events()->withAll()->find($therapist_event->id);
        $therapist_event = new EventsResource($therapist_event);
        $response = generateResponse($therapist_event,true,'TherapistEvent Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistEvent Status***********/
    public function updateStatus(Request $request,Event $therapist_event){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_event->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_event->update([
          'is_active' => $therapist_event->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistEvent Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistEvent ***********/
    public function destroy(Request $request,Event $therapist_event)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_event->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_event->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_event->delete();
          }
          $response = generateResponse(null,true,'TherapistEvent Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistEvent ***********/
    public function destroyPermanently(Request $request,$therapist_event)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_event = $therapist->therapist_events()->withTrashed()->find($therapist_event);
        if($therapist_event){
            if($therapist_event->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_event->trashed()) {
            $therapist_event->forceDelete();
            $response = generateResponse(null,true,'TherapistEvent Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistEvent is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistEvent not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistEvent ***********/
    public function restore(Request $request,$therapist_event)
    {
      $therapist= auth()->user()->therapist;
      $therapist_event = $therapist->therapist_events()->withTrashed()->find($therapist_event);
          if ($therapist_event->trashed()) {
            $therapist_event->restore();
            $response = generateResponse(null,true,'TherapistEvent Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistEvent is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
